/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.attribute.serialization;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IModifierOp;
import dev.toma.gunsrpg.api.common.attribute.IModifierSerializer;
import dev.toma.gunsrpg.common.attribute.AttributeModifier;
import dev.toma.gunsrpg.common.attribute.AttributeOps;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public final class DefaultModifierSerializer
implements IModifierSerializer<AttributeModifier> {
    private static final ResourceLocation UID = GunsRPG.makeResource("attribute");

    @Override
    public ResourceLocation getSerializerUid() {
        return UID;
    }

    @Override
    public void toNbtStructure(AttributeModifier modifier, CompoundNBT nbt) {
        nbt.func_186854_a("uid", modifier.getUid());
        nbt.func_74778_a("op", modifier.getOperation().getId().toString());
        nbt.func_74780_a("value", modifier.getModifierValue());
    }

    @Override
    public AttributeModifier fromNbtStructure(CompoundNBT data) {
        UUID uuid = data.func_186857_a("uid");
        ResourceLocation opKey = new ResourceLocation(data.func_74779_i("op"));
        double value = data.func_74769_h("value");
        IModifierOp op = AttributeOps.find(opKey);
        return new AttributeModifier(uuid, op, value);
    }
}

